<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: livekit_sip.proto

namespace Livekit;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A SIP Participant is a singular SIP session connected to a LiveKit room via
 * a SIP Trunk into a SIP DispatchRule
 *
 * Generated from protobuf message <code>livekit.CreateSIPParticipantRequest</code>
 */
class CreateSIPParticipantRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * What SIP Trunk should be used to dial the user
     *
     * Generated from protobuf field <code>string sip_trunk_id = 1;</code>
     */
    protected $sip_trunk_id = '';
    /**
     * What number should be dialed via SIP
     *
     * Generated from protobuf field <code>string sip_call_to = 2;</code>
     */
    protected $sip_call_to = '';
    /**
     * What LiveKit room should this participant be connected too
     *
     * Generated from protobuf field <code>string room_name = 3;</code>
     */
    protected $room_name = '';
    /**
     * Optional identity of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_identity = 4;</code>
     */
    protected $participant_identity = '';
    /**
     * Optional name of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_name = 7;</code>
     */
    protected $participant_name = '';
    /**
     * Optional user-defined metadata. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>string participant_metadata = 8;</code>
     */
    protected $participant_metadata = '';
    /**
     * Optional user-defined attributes. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>map<string, string> participant_attributes = 9;</code>
     */
    private $participant_attributes;
    /**
     * Optionally send following DTMF digits (extension codes) when making a call.
     * Character 'w' can be used to add a 0.5 sec delay.
     *
     * Generated from protobuf field <code>string dtmf = 5;</code>
     */
    protected $dtmf = '';
    /**
     * Optionally play ringtone in the room as an audible indicator for existing participants
     *
     * Generated from protobuf field <code>bool play_ringtone = 6;</code>
     */
    protected $play_ringtone = false;
    /**
     * By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     * If true, a random value for identity will be used and numbers will be omitted from attributes.
     *
     * Generated from protobuf field <code>bool hide_phone_number = 10;</code>
     */
    protected $hide_phone_number = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $sip_trunk_id
     *           What SIP Trunk should be used to dial the user
     *     @type string $sip_call_to
     *           What number should be dialed via SIP
     *     @type string $room_name
     *           What LiveKit room should this participant be connected too
     *     @type string $participant_identity
     *           Optional identity of the participant in LiveKit room
     *     @type string $participant_name
     *           Optional name of the participant in LiveKit room
     *     @type string $participant_metadata
     *           Optional user-defined metadata. Will be attached to a created Participant in the room.
     *     @type array|\Google\Protobuf\Internal\MapField $participant_attributes
     *           Optional user-defined attributes. Will be attached to a created Participant in the room.
     *     @type string $dtmf
     *           Optionally send following DTMF digits (extension codes) when making a call.
     *           Character 'w' can be used to add a 0.5 sec delay.
     *     @type bool $play_ringtone
     *           Optionally play ringtone in the room as an audible indicator for existing participants
     *     @type bool $hide_phone_number
     *           By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     *           If true, a random value for identity will be used and numbers will be omitted from attributes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\LivekitSip::initOnce();
        parent::__construct($data);
    }

    /**
     * What SIP Trunk should be used to dial the user
     *
     * Generated from protobuf field <code>string sip_trunk_id = 1;</code>
     * @return string
     */
    public function getSipTrunkId()
    {
        return $this->sip_trunk_id;
    }

    /**
     * What SIP Trunk should be used to dial the user
     *
     * Generated from protobuf field <code>string sip_trunk_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSipTrunkId($var)
    {
        GPBUtil::checkString($var, True);
        $this->sip_trunk_id = $var;

        return $this;
    }

    /**
     * What number should be dialed via SIP
     *
     * Generated from protobuf field <code>string sip_call_to = 2;</code>
     * @return string
     */
    public function getSipCallTo()
    {
        return $this->sip_call_to;
    }

    /**
     * What number should be dialed via SIP
     *
     * Generated from protobuf field <code>string sip_call_to = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSipCallTo($var)
    {
        GPBUtil::checkString($var, True);
        $this->sip_call_to = $var;

        return $this;
    }

    /**
     * What LiveKit room should this participant be connected too
     *
     * Generated from protobuf field <code>string room_name = 3;</code>
     * @return string
     */
    public function getRoomName()
    {
        return $this->room_name;
    }

    /**
     * What LiveKit room should this participant be connected too
     *
     * Generated from protobuf field <code>string room_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRoomName($var)
    {
        GPBUtil::checkString($var, True);
        $this->room_name = $var;

        return $this;
    }

    /**
     * Optional identity of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_identity = 4;</code>
     * @return string
     */
    public function getParticipantIdentity()
    {
        return $this->participant_identity;
    }

    /**
     * Optional identity of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_identity = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setParticipantIdentity($var)
    {
        GPBUtil::checkString($var, True);
        $this->participant_identity = $var;

        return $this;
    }

    /**
     * Optional name of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_name = 7;</code>
     * @return string
     */
    public function getParticipantName()
    {
        return $this->participant_name;
    }

    /**
     * Optional name of the participant in LiveKit room
     *
     * Generated from protobuf field <code>string participant_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setParticipantName($var)
    {
        GPBUtil::checkString($var, True);
        $this->participant_name = $var;

        return $this;
    }

    /**
     * Optional user-defined metadata. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>string participant_metadata = 8;</code>
     * @return string
     */
    public function getParticipantMetadata()
    {
        return $this->participant_metadata;
    }

    /**
     * Optional user-defined metadata. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>string participant_metadata = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setParticipantMetadata($var)
    {
        GPBUtil::checkString($var, True);
        $this->participant_metadata = $var;

        return $this;
    }

    /**
     * Optional user-defined attributes. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>map<string, string> participant_attributes = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParticipantAttributes()
    {
        return $this->participant_attributes;
    }

    /**
     * Optional user-defined attributes. Will be attached to a created Participant in the room.
     *
     * Generated from protobuf field <code>map<string, string> participant_attributes = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParticipantAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->participant_attributes = $arr;

        return $this;
    }

    /**
     * Optionally send following DTMF digits (extension codes) when making a call.
     * Character 'w' can be used to add a 0.5 sec delay.
     *
     * Generated from protobuf field <code>string dtmf = 5;</code>
     * @return string
     */
    public function getDtmf()
    {
        return $this->dtmf;
    }

    /**
     * Optionally send following DTMF digits (extension codes) when making a call.
     * Character 'w' can be used to add a 0.5 sec delay.
     *
     * Generated from protobuf field <code>string dtmf = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDtmf($var)
    {
        GPBUtil::checkString($var, True);
        $this->dtmf = $var;

        return $this;
    }

    /**
     * Optionally play ringtone in the room as an audible indicator for existing participants
     *
     * Generated from protobuf field <code>bool play_ringtone = 6;</code>
     * @return bool
     */
    public function getPlayRingtone()
    {
        return $this->play_ringtone;
    }

    /**
     * Optionally play ringtone in the room as an audible indicator for existing participants
     *
     * Generated from protobuf field <code>bool play_ringtone = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setPlayRingtone($var)
    {
        GPBUtil::checkBool($var);
        $this->play_ringtone = $var;

        return $this;
    }

    /**
     * By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     * If true, a random value for identity will be used and numbers will be omitted from attributes.
     *
     * Generated from protobuf field <code>bool hide_phone_number = 10;</code>
     * @return bool
     */
    public function getHidePhoneNumber()
    {
        return $this->hide_phone_number;
    }

    /**
     * By default the From value (Phone number) is used for participant name/identity (if not set) and added to attributes.
     * If true, a random value for identity will be used and numbers will be omitted from attributes.
     *
     * Generated from protobuf field <code>bool hide_phone_number = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setHidePhoneNumber($var)
    {
        GPBUtil::checkBool($var);
        $this->hide_phone_number = $var;

        return $this;
    }

}

